package com.example.sefinsa_app.utilities;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.text.Html;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.net.ParseException;
import androidx.navigation.Navigation;
import androidx.recyclerview.widget.RecyclerView;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Aval;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.gson.Gson;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AvalesAdapter extends RecyclerView.Adapter<AvalesAdapter.AvalesViewHolder> {

    Context context;
    ArrayList<Aval> avales;
    private SharedPreferences sesion;
    private String aval_id;
    private VolleyS vs;
    private RequestQueue requestQueue;
    public AvalesAdapter(Context context, ArrayList<Aval> avales) {
        this.context = context;
        this.avales = avales;
    }

    public void setListaFiltrada(ArrayList<Aval> filteredListEstaciones) {
        this.avales = (filteredListEstaciones != null) ? filteredListEstaciones : new ArrayList<>();
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public AvalesViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        sesion = context.getSharedPreferences("sesion", Context.MODE_PRIVATE);
        View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.aval_item_2, parent, false);
        return new AvalesViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull AvalesViewHolder holder, int position) {
        try {
            if (avales != null && position >= 0 && position < avales.size()) {
                Aval aval = avales.get(position);
                if (aval != null) {
                    holder.imprimir(position);
                } else {
                    holder.imprimirDefault();
                }
            } else {
                holder.imprimirDefault();
            }
        } catch (Exception e) {
            Log.e("AvalesAdapter", "Error en onBindViewHolder", e);
        }
    }


    @Override
    public int getItemCount() {
        if (avales == null) {
            Log.e("AvalesAdapter", "Lista de avales es nula");
            return 0;
        }
        return avales.size();
    }


    public void clear() {
        avales.clear();
        notifyDataSetChanged();
    }

    public void addAll(ArrayList<Aval> list) {
        avales = list;
        notifyDataSetChanged();
    }
    private void refreshData() {
        requestQueue.getCache().clear();
    }
    public void updateData(ArrayList<Aval> nuevosAvales) {
        this.avales.addAll(nuevosAvales);
        notifyDataSetChanged();
    }
    public class AvalesViewHolder extends RecyclerView.ViewHolder {

        TextView tvNombreAval, tvDireccionAval, tvTelefonoAval, tvGarantiasAval;

        Button btnEditarAval, btnVerInfoAval, btnVerImagenes,btnGenerarPrestamoAval;
        String informacion = "";
        ConstraintLayout tarjetaAval;
        public AvalesViewHolder(@NonNull View itemView) {
            super(itemView);
            tarjetaAval = itemView.findViewById(R.id.TarjetaAval);
            tvNombreAval = itemView.findViewById(R.id.nombreAvalTarjeta);
            tvTelefonoAval = itemView.findViewById(R.id.telefonoaval);
            btnEditarAval = itemView.findViewById(R.id.btnEditarAvalTarjeta);
            btnVerInfoAval = itemView.findViewById(R.id.btnVerInfoTarjeta);
            btnVerImagenes = itemView.findViewById(R.id.btnVerImagenesTarjeta);
            btnGenerarPrestamoAval = itemView.findViewById(R.id.btnGenerarPrestamoAval);
        }
        public void imprimirDefault() {
            if (tvNombreAval != null) tvNombreAval.setText("Nombre Predeterminado");
            if (tvTelefonoAval != null) tvTelefonoAval.setText("0000000000");

            // Ocultar botones para un estado predeterminado
            if (btnEditarAval != null) btnEditarAval.setVisibility(View.VISIBLE);
            if (btnVerInfoAval != null) btnVerInfoAval.setVisibility(View.VISIBLE);
            if (btnVerImagenes != null) btnVerImagenes.setVisibility(View.VISIBLE);
            if (btnGenerarPrestamoAval != null) btnGenerarPrestamoAval.setVisibility(View.VISIBLE);
        }


        private void showAlert(String message) {
            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            builder.setMessage(message);

            TextView title = new TextView(context);
            title.setText("Alerta");
            title.setGravity(Gravity.CENTER);
            title.setTextSize(TypedValue.COMPLEX_UNIT_SP, 20);
            title.setTextColor(ContextCompat.getColor(context, android.R.color.black));
            title.setPadding(0, 20, 0, 20);

            builder.setCustomTitle(title);

            builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                public void onClick(DialogInterface dialog, int id) {
                    // Acciones al hacer clic en Aceptar
                }
            });

            AlertDialog dialog = builder.create();
            dialog.show();
        }
        private RequestQueue requestQueue;

        public void imprimir(int position) {
            vs = VolleyS.getInstance(context);
            requestQueue = vs.getRequestQueue();
            String nombre_aval = avales.get(position).getNombre_completo();
            tvNombreAval.setText("\nAVAL: " + nombre_aval);

            tvTelefonoAval.setText(avales.get(position).getTelefono());

            informacion = "<b>Aval:</b> " + avales.get(position).getNombre_completo() + " <br><br> " +
                    "<b>Dirección:</b> " + avales.get(position).getDireccion() + " <br><br> " +
                    "<b>Teléfono:</b> " + avales.get(position).getTelefono() + " <br><br> " +
                    "<b>Otras referencías:</b> " + avales.get(position).getOtras_referencias() + " <br><br> " +
                    "<b>Garantías:</b> " + avales.get(position).getGarantias() + " <br><br> ";

            if (sesion.getString("nombre_perfil", "").equals("Administrador")
                    || sesion.getString("nombre_perfil", "").equals("ADMINISTRADOR")) {

                btnGenerarPrestamoAval.setVisibility(View.GONE);
                btnEditarAval.setVisibility(View.VISIBLE);
                btnVerImagenes.setVisibility(View.VISIBLE);
                //int desiredWidth = 41; // Ancho en dp
                int desiredWidth = 74;
                float scale = context.getResources().getDisplayMetrics().density;
                int desiredWidthPx = (int) (desiredWidth * scale + 0.5f);

                ViewGroup.LayoutParams paramsVerInfo = btnVerInfoAval.getLayoutParams();
                paramsVerInfo.width = desiredWidthPx;
                btnVerInfoAval.setLayoutParams(paramsVerInfo);

                ViewGroup.LayoutParams paramsVerImg = btnVerImagenes.getLayoutParams();
                paramsVerImg.width = desiredWidthPx;
                btnVerImagenes.setLayoutParams(paramsVerImg);

                ViewGroup.LayoutParams paramsGenerarPrestamo = btnGenerarPrestamoAval.getLayoutParams();
                paramsGenerarPrestamo.width = desiredWidthPx;
                btnGenerarPrestamoAval.setLayoutParams(paramsGenerarPrestamo);

                btnGenerarPrestamoAval.setOnClickListener(view -> {

                    // Tarea normal
                    Bundle args = new Bundle();
                    String personJsonString = Utils.getGsonParser().toJson(avales.get(position));
                    args.putString("aval", personJsonString);

                    Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard)
                            .navigate(R.id.nav_prestamos_crear, args);

                });

                ViewGroup.LayoutParams paramsEditarAval = btnEditarAval.getLayoutParams();
                paramsEditarAval.width = desiredWidthPx;
                btnEditarAval.setLayoutParams(paramsEditarAval);

            } else if (sesion.getString("nombre_perfil", "").equals("VOCERO") ) {

                btnVerImagenes.setVisibility(View.VISIBLE);

                int desiredWidth = 74;
                float scale = context.getResources().getDisplayMetrics().density;
                int desiredWidthPx = (int) (desiredWidth * scale + 0.5f);

                ViewGroup.LayoutParams paramsVerImagenes = btnVerImagenes.getLayoutParams();
                paramsVerImagenes.width = desiredWidthPx;
                btnVerImagenes.setLayoutParams(paramsVerImagenes);

            } else if (sesion.getString("nombre_perfil", "").equals("COBRADOR") ||
                    sesion.getString("nombre_perfil", "").equals("GESTOR")) {

                btnEditarAval.setVisibility(View.GONE);
                btnVerImagenes.setVisibility(View.VISIBLE);
            } else {

                btnEditarAval.setVisibility(View.VISIBLE);
            }
            btnEditarAval.setOnClickListener(view -> {
                Bundle args = new Bundle();
                String personJsonString = Utils.getGsonParser().toJson(avales.get(position));
                args.putString("aval", personJsonString);

                Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard)
                        .navigate(R.id.nav_avales_editar, args);
            });
            btnVerImagenes.setOnClickListener(view -> {

                String[] opciones = {
                        "Tomar fotos",
                        "Ver expediente",
                };

                new MaterialAlertDialogBuilder(context)
                        .setTitle("Opciones")
                        .setSingleChoiceItems(opciones, -1, (dialogInterface, i) -> {


                            switch (i) {

                                case 0:

                                    dialogInterface.dismiss();
                                    aval_id = avales.get(position).id;
                                    Log.d("LISTA0", "DATO DE aval_id para FOTOS: "+aval_id);

                                    Bundle args2 = new Bundle();
                                    String personJsonString2 = Utils.getGsonParser().toJson(avales.get(position));
                                    String personJsonString4 = nombre_aval;
                                    args2.putString("aval", personJsonString2);
                                    args2.putString("avalNombre", personJsonString4);

                                    Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard)
                                            .navigate(R.id.nav_avales_fotos, args2);

                                    break;

                                case 1:
                                    dialogInterface.dismiss();

                                    Bundle args = new Bundle();
                                    String personJsonString = Utils.getGsonParser().toJson(avales.get(position));
                                    String personJsonString3 = avales.get(position).id;

                                    // Agregar los datos al Bundle
                                    args.putString("aval", personJsonString);
                                    args.putString("avalId", personJsonString3);

                                    // Agregar Log para ver los datos que se envían
                                    Log.d("DATA_ENVIADA", "Json de avale: " + personJsonString);
                                    Log.d("DATA_ENVIADA", "ID de avaleId: " + personJsonString3);

                                    // Navegar a nav_avales_documentos con los argumentos
                                    Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard)
                                            .navigate(R.id.nav_avales_documentos, args);

                                    break;


                            }
                        }).show();

            });
            btnVerInfoAval.setOnClickListener(view -> {
                final View dialogView = LayoutInflater.from(context).inflate(R.layout.dialog_info_aval, null, false);

                TextView tvNombreAval = dialogView.findViewById(R.id.tvNombreAvalEnAval);
                TextView tvDireccionAval = dialogView.findViewById(R.id.tvDireccionAvalEnAval);
                TextView tvTelefonoAval = dialogView.findViewById(R.id.tvTelefonoAvalEnAval);
                TextView tvGarantiasAval = dialogView.findViewById(R.id.tvGarantiasAvalEnAval);
                TextView tvUpdGarantiasAval = dialogView.findViewById(R.id.tvUpdGarantiasAvalEnAval);
                TextView tvUpdComprobantesAval = dialogView.findViewById(R.id.tvUpdComprobantesAvalEnAval);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) TextView tvMapaAval = dialogView.findViewById(R.id.tvMapaAval);

                tvNombreAval.setText(Html.fromHtml("<b>Aval:</b> " + avales.get(position).getNombre_completo()));
                tvMapaAval.setText(Html.fromHtml("<b>Ver ubicación</b> "));
                tvDireccionAval.setText(Html.fromHtml("<b>Dirección:</b> " + avales.get(position).getDireccion()));
                tvTelefonoAval.setText(Html.fromHtml("<b>Teléfono:</b> " + avales.get(position).getTelefono()));
                tvGarantiasAval.setText(Html.fromHtml("<b>Garantías:</b> " + avales.get(position).getGarantias()));

                Log.d("MyWorker", "INFORMACION EN CLIENTE SELECCIONADO........" + avales.get(position).getUpdate_comprobantes_Enaval() +
                        " / " + avales.get(position).getUpdate_garantias_Enaval());

                String updateGarantiasAval = avales.get(position).getUpdate_garantias_Enaval();
                String updateComprobantesAval = avales.get(position).getUpdate_comprobantes_Enaval();
                updateComprobantesAval = updateComprobantesAval != null ? updateComprobantesAval : "...";
                updateGarantiasAval = updateGarantiasAval != null ? updateGarantiasAval : "...";

                JSONObject data2 = new JSONObject();
                try {
                    data2.put("func", "coordenadasAval");
                    data2.put("aval_id", avales.get(position).getId());
                } catch (JSONException e) {
                    e.printStackTrace();
                }

                Log.d("11", "loadAllData: ");

                JsonObjectRequest req2 = new JsonObjectRequest(Request.Method.POST, API.urlClientes, data2,
                        new Response.Listener<JSONObject>() {
                            @Override
                            public void onResponse(JSONObject response) {
                                try {
                                    if (!response.get("data").toString().equals("false")) {
                                        JSONObject jsonObject = (JSONObject) response.get("data");

                                        String latitud = jsonObject.getString("latitud");
                                        String longitud = jsonObject.getString("longitud");

                                        if (latitud.isEmpty() && longitud.isEmpty() || latitud == null && longitud == null || latitud.equals("0") && longitud.equals("0") || latitud.equals("null") && longitud.equals("null")) {
                                            tvMapaAval.setText("");
                                        } else {
                                            tvMapaAval.setOnClickListener(new View.OnClickListener() {
                                                @Override
                                                public void onClick(View v) {
                                                    Log.d("qpwopeoqpww", "geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud);
                                                    Intent intent = new Intent(android.content.Intent.ACTION_VIEW);
                                                    intent.setData(Uri.parse("geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud));
                                                    intent.setPackage("com.google.android.apps.maps");
                                                    context.startActivity(intent);
                                                }
                                            });
                                        }
                                    }
                                } catch (JSONException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        },
                        new Response.ErrorListener() {
                            @Override public void onErrorResponse(VolleyError error) { }
                        });

                requestQueue.add(req2);

                updateGarantiasAval = formatFecha(updateGarantiasAval);
                updateComprobantesAval = formatFecha(updateComprobantesAval);

                tvUpdGarantiasAval.setText(Html.fromHtml("<b>Últimas fotos Garantías:</b><br>" + updateGarantiasAval));
                tvUpdComprobantesAval.setText(Html.fromHtml("<b>Últimas fotos Comprobantes:</b><br>" + updateComprobantesAval));

                tvTelefonoAval.setOnClickListener(view12 -> {
                    Intent intent = new Intent(Intent.ACTION_DIAL);
                    intent.setData(Uri.parse("tel:" + avales.get(position).getTelefono()));
                    context.startActivity(intent);
                });

                new MaterialAlertDialogBuilder(context)
                        .setTitle("")
                        .setView(dialogView)
                        .setPositiveButton("Cerrar", (dialogInterface, i) -> {

                        })
                        .show();
            });

        }
        private String formatFecha(String fecha) {
            if (fecha == null) {
                return "...";
            }

            SimpleDateFormat originalFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat desiredFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            try {
                Date date = originalFormat.parse(fecha);
                return desiredFormat.format(date);
            } catch (ParseException | java.text.ParseException e) {
                e.printStackTrace();
                return "...";
            }
        }
    }
}
